/*
 * Decompiled with CFR 0.152.
 */
package com.xlnt.utils;

import com.xlnt.utils.Link;
import com.xlnt.utils.Ref;
import java.io.File;
import java.io.IOException;

public final class LinkDefault
extends Link {
    public String resolveLink(String filepath, Ref linkpath) {
        String path;
        File f = new File(filepath);
        try {
            path = f.getCanonicalPath();
        }
        catch (IOException e) {
            path = f.getAbsolutePath();
        }
        if (linkpath != null) {
            String p_str = f.getParent();
            if (p_str != null) {
                String p_path;
                File p = new File(p_str);
                try {
                    p_path = p.getCanonicalPath();
                }
                catch (IOException e) {
                    p_path = p.getAbsolutePath();
                }
                p_path = p_path + File.separator + f.getName();
                linkpath.set(new File(p_path).getAbsolutePath());
            } else {
                linkpath.set(f.getAbsolutePath());
            }
        }
        return path;
    }

    public String resolveLink(String filepath) {
        return this.resolveLink(filepath, null);
    }

    public boolean createLink(String target_, String path_) {
        Runtime rt = Runtime.getRuntime();
        String[] args = new String[]{"/bin/ln", "-s", target_, path_};
        try {
            Process p = rt.exec(args);
            int rc = -1;
            while (rc == -1) {
                try {
                    rc = p.waitFor();
                }
                catch (InterruptedException e) {}
            }
            return rc == 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean deleteLink(String path_) {
        Runtime rt = Runtime.getRuntime();
        String[] args = new String[]{"/bin/rm", path_};
        try {
            Process p = rt.exec(args);
            int rc = -1;
            while (rc == -1) {
                try {
                    rc = p.waitFor();
                }
                catch (InterruptedException e) {}
            }
            return rc == 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String ext() {
        return "";
    }
}

